# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PoolResizeParameter(Model):
    """Parameters for a CloudPoolOperations.Resize request.

    :param target_dedicated: The desired number of compute nodes in the pool.
    :type target_dedicated: int
    :param resize_timeout: The timeout for allocation of compute nodes to the
     pool or removal of compute nodes from the pool. The default value is 10
     minutes.
    :type resize_timeout: timedelta
    :param node_deallocation_option: When nodes may be removed from the pool,
     if the pool size is decreasing. Possible values include: 'requeue',
     'terminate', 'taskcompletion', 'retaineddata'
    :type node_deallocation_option: str or
     :class:`ComputeNodeDeallocationOption
     <azure.batch.models.ComputeNodeDeallocationOption>`
    """ 

    _validation = {
        'target_dedicated': {'required': True},
    }

    _attribute_map = {
        'target_dedicated': {'key': 'targetDedicated', 'type': 'int'},
        'resize_timeout': {'key': 'resizeTimeout', 'type': 'duration'},
        'node_deallocation_option': {'key': 'nodeDeallocationOption', 'type': 'ComputeNodeDeallocationOption'},
    }

    def __init__(self, target_dedicated, resize_timeout=None, node_deallocation_option=None):
        self.target_dedicated = target_dedicated
        self.resize_timeout = resize_timeout
        self.node_deallocation_option = node_deallocation_option
